@extends('layouts.app')
@section('title', __('messages.edit'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('messages.edit') - @lang('lang_v1.purchase_requisition_details')</h1>
    <p class="help-block">@lang('purchase.ref_no'): {{ $purchase->ref_no }}</p>
    <p class="help-block">@lang('messages.location'): {{ $purchase->location->name ?? '' }}</p>
</section>

<section class="content">
    {!! Form::open(['url' => action([\App\Http\Controllers\PurchaseRequisitionController::class, 'update'], [$purchase->id]), 'method' => 'PUT', 'id' => 'edit_purchase_requisition_form' ]) !!}

    @component('components.widget', ['class' => 'box-solid'])
        <div class="row">
            <div class="col-sm-4">
                <div class="form-group">
                    {!! Form::label('priority_level', __('lang_v1.priority_level') . ':') !!}
                    {!! Form::select('priority_level', $priority_levels, $purchase->priority_level, ['class' => 'form-control select2', 'id' => 'priority_level']); !!}
                </div>
            </div>
            <div class="col-sm-4 @if(!session('business.enable_category')) hide @endif">
                <div class="form-group">
                    {!! Form::label('category_id', __('product.category') . ':') !!}
                    {!! Form::select('category_id[]', $categories, null, ['class' => 'form-control select2', 'multiple', 'id' => 'category_id']); !!}
                </div>
            </div>
            <div class="col-sm-4">
                <div class="form-group">
                    {!! Form::label('location_id', __('purchase.business_location').':') !!}
                    {!! Form::select('location_id', $business_locations, $purchase->location_id, ['class' => 'form-control select2', 'id' => 'location_id']) !!}
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <label for="search_product_for_pr" class="control-label">@lang('sale.product') - @lang('messages.add')</label>
                <input type="text" id="search_product_for_pr" class="form-control" placeholder="@lang('lang_v1.search_product')" {{ empty($purchase->location_id) ? 'disabled' : '' }}>
                <p class="help-block">@lang('lang_v1.search_product_placeholder')</p>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-solid'])
        <div class="row">
            <div class="col-sm-6">
                <div class="form-group">
                    {!! Form::label('delivery_date', __('lang_v1.required_by_date') . ':') !!}
                    <div class="input-group">
                        <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                        <input type="datetime-local" name="delivery_date" id="delivery_date" class="form-control" value="{{ !empty($purchase->delivery_date) ? date('Y-m-d\TH:i', strtotime($purchase->delivery_date)) : '' }}">
                    </div>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="form-group">
                    {!! Form::label('status', __('sale.status') . ':') !!}
                    {!! Form::select('status', $pr_statuses, $purchase->status, ['class' => 'form-control select2']) !!}
                </div>
            </div>
            <div class="col-sm-12">
                <div class="form-group">
                    {!! Form::label('additional_notes', __('lang_v1.requested_note') . ':') !!}
                    {!! Form::textarea('additional_notes', $purchase->additional_notes, [
                        'class' => 'form-control js-auto-resize-textarea',
                        'rows' => 4,
                        'readonly' => true,
                        'style' => 'background-color:#f8f9fa; cursor:not-allowed;'
                    ]) !!}
                    <p class="help-block" style="margin-top:4px;">@lang('lang_v1.requested_note_locked')</p>
                </div>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-solid'])
        <div class="row">
            <div class="col-sm-12">
                <label class="control-label">@lang('lang_v1.additional_notes'):</label>
                <div id="tx-comments-list" class="well well-sm" style="max-height: 260px; overflow:auto; background:#fff;">
                    @if(isset($txComments) && $txComments->count())
                        @foreach($txComments as $c)
                            <div style="padding:6px 8px; border-bottom:1px solid #eee;">
                                <div style="font-weight:600">{{ $c->user_first_name }}@if(!empty($c->user_role)) &bull; {{ $c->user_role }} @endif</div>
                                <div style="white-space:pre-wrap">{{ $c->comment }}</div>
                                <div class="text-muted" style="font-size:12px">{{ optional($c->created_at)->format('Y-m-d H:i') }}</div>
                            </div>
                        @endforeach
                    @else
                        <div class="text-muted">@lang('lang_v1.no_comments_yet')</div>
                    @endif
                </div>
                <div class="input-group" style="margin-top:8px;">
                    <textarea id="tx-new-comment" class="form-control" rows="2" placeholder="@lang('lang_v1.add_a_comment')"></textarea>
                    <span class="input-group-btn">
                        <button id="tx-post-comment" class="btn btn-primary" type="button">@lang('messages.post')</button>
                    </span>
                </div>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-solid'])
        <div class="row">
            <div class="col-md-12">
                <table class="table" id="products_list">
                    <thead>
                        <tr>
                            <th width="30%">@lang('sale.product')</th>
                            <th width="12%">@lang('product.alert_quantity')</th>
                            <th width="12%">@lang('product.max_quantity')</th>
                            <th width="16%">@lang('purchase.unit_cost')</th>
                            <th width="25%">@lang('lang_v1.required_quantity')</th>
                            <th width="5%"><i class="text-danger fas fa-trash"></i></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($purchase->purchase_lines as $purchase_line)
                            @php
                                $check_decimal = optional($purchase_line->product->unit)->allow_decimal;
                                $check_decimal_second_unit = optional($purchase_line->product->second_unit)->allow_decimal;
                            @endphp
                            <tr data-variation_id="{{$purchase_line->variation_id}}">
                                <td>
                                    {{$purchase_line->product->name}}
                                    @if($purchase_line->product->type == 'single')
                                        ({{$purchase_line->product->sku}})
                                    @else
                                        - {{$purchase_line->variations->product_variation->name}} - {{$purchase_line->variations->name}} ({{$purchase_line->variations->sub_sku}})
                                    @endif
                                    @php
                                        $__stock = isset($stocks_by_variation[$purchase_line->variation_id]) ? (float)$stocks_by_variation[$purchase_line->variation_id] : null;
                                    @endphp
                                    @if(!is_null($__stock))
                                        <p class="help-block">@lang('report.current_stock'): {{ @format_quantity($__stock) }} {{$purchase_line->product->unit->short_name ?? ''}}</p>
                                    @endif
                                </td>
                                <td>{{ !is_null($purchase_line->product->alert_quantity) ? @format_quantity($purchase_line->product->alert_quantity) : '--' }} {{$purchase_line->product->unit->short_name ?? ''}}</td>
                                <td>{{ !is_null($purchase_line->product->max_quantity) ? @format_quantity($purchase_line->product->max_quantity) : '--' }} {{ !is_null($purchase_line->product->max_quantity) ? ($purchase_line->product->unit->short_name ?? '') : '' }}</td>
                                <td>
                                    @php
                                        $unit_cost = $purchase_line->purchase_price_inc_tax ?? $purchase_line->purchase_price ?? $purchase_line->variations->default_purchase_price ?? 0;
                                    @endphp
                                    <input type="text"
                                        name="purchases[{{$purchase_line->variation_id}}][unit_cost]"
                                        value="{{ @num_format($unit_cost) }}"
                                        class="form-control input-sm input_number"
                                        required>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="hidden" name="purchases[{{$purchase_line->variation_id}}][product_id]" value="{{$purchase_line->product_id}}">
                                        <input type="hidden" name="purchases[{{$purchase_line->variation_id}}][variation_id]" value="{{$purchase_line->variation_id}}">
                                        <input type="text"
                                            name="purchases[{{$purchase_line->variation_id}}][quantity]"
                                            value="{{ @format_quantity($purchase_line->quantity) }}"
                                            class="form-control input-sm input_number mousetrap"
                                            required
                                            @if($check_decimal)
                                                data-decimal=1
                                            @else
                                                data-decimal=0
                                                data-rule-abs_digit="true"
                                                data-msg-abs_digit="@lang('lang_v1.decimal_value_not_allowed')"
                                            @endif>
                                        <div class="input-group-addon">{{$purchase_line->product->unit->short_name ?? ''}}</div>
                                    </div>
                                    @if(!empty($purchase_line->product->second_unit))
                                        <br>
                                        <label>@lang('lang_v1.second_quantity')</label>
                                        <div class="input-group">
                                            <input type="text"
                                                name="purchases[{{$purchase_line->variation_id}}][secondary_unit_quantity]"
                                                value="{{ @format_quantity($purchase_line->secondary_unit_quantity) }}"
                                                class="form-control input-sm input_number mousetrap"
                                                required
                                                data-rule-abs_digit={{$check_decimal_second_unit}}
                                                data-msg-abs_digit="{{__('lang_v1.decimal_value_not_allowed')}}">
                                            <div class="input-group-addon">{{$purchase_line->product->second_unit->short_name}}</div>
                                        </div>
                                    @endif
                                </td>
                                <td>
                                    <button type="button" class="btn btn-danger btn-xs remove_product_line"><i class="fas fa-times"></i></button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 text-center">
                <button type="submit" class="tw-dw-btn tw-dw-btn-primary tw-text-white tw-dw-btn-lg">@lang('messages.save')</button>
                <a href="{{ action([\App\Http\Controllers\PurchaseRequisitionController::class, 'index']) }}" class="tw-dw-btn tw-dw-btn-neutral tw-text-white tw-dw-btn-lg">@lang('messages.cancel')</a>
            </div>
        </div>
    @endcomponent

    {!! Form::close() !!}
</section>
@endsection

@section('javascript')
<script type="text/javascript">
$(document).ready(function(){
    if (typeof window.initAutoResizeTextareas !== 'function') {
        window.initAutoResizeTextareas = function(context){
            $(context || document).find('textarea.js-auto-resize-textarea').each(function(){
                var el = this;
                var $el = $(el);
                if (!$el.data('autoResizeMinHeight')) {
                    var rows = parseInt($el.attr('rows'), 10) || 2;
                    var lineHeight = parseFloat($el.css('line-height')) || 20;
                    $el.data('autoResizeMinHeight', rows * lineHeight);
                }
                var minHeight = $el.data('autoResizeMinHeight');
                var resize = function(){
                    el.style.height = 'auto';
                    var newHeight = Math.max(el.scrollHeight, minHeight);
                    el.style.height = (newHeight + 2) + 'px';
                };
                $el.css('overflow', 'hidden');
                resize();
                $el.off('input.autoResize').on('input.autoResize', resize);
            });
        };
    }
    window.initAutoResizeTextareas();
    // Enable/disable search input based on location
    $('select#location_id').on('change', function(){
        if($(this).val()){ $('#search_product_for_pr').removeAttr('disabled'); } else { $('#search_product_for_pr').attr('disabled','disabled'); }
    }).trigger('change');

    // Autocomplete for adding arbitrary products to PR
    if ($('#search_product_for_pr').length > 0) {
        $('#search_product_for_pr')
            .autocomplete({
                source: function(request, response) {
                    $.getJSON(
                        '{{ url('/products/list') }}',
                        { location_id: $('#location_id').val(), term: request.term },
                        response
                    );
                },
                minLength: 2,
                response: function(event, ui) {
                    if (ui.content.length == 1) {
                        ui.item = ui.content[0];
                        $(this)
                            .data('ui-autocomplete')
                            ._trigger('select', 'autocompleteselect', ui);
                        $(this).autocomplete('close');
                    } else if (ui.content.length == 0) {
                        swal(LANG.no_products_found);
                    }
                },
                select: function(event, ui) {
                    $(this).val(null);
                    pr_add_product_row(ui.item.variation_id);
                }
            })
            .autocomplete('instance')._renderItem = function(ul, item) {
            var label = '<div>' + item.name + (item.type=='variable' ? (' - ' + item.variation) : '') + ' (' + item.sub_sku + ')</div>';
            return $('<li>').append(label).appendTo(ul);
        };
    }

    window.pr_add_product_row = function(variation_id){
        $.ajax({
            method: 'post',
            url: '{{ route('pr.get_product_row') }}',
            data: { variation_id: variation_id, location_id: $('#location_id').val(), _token: $('meta[name="csrf-token"]').attr('content') },
            success: function(result){
                var rows = $(result);
                rows.find('tr').each(function(){
                    var id = $(this).attr('data-variation_id');
                    if ($('tr[data-variation_id="' + id + '"]').length == 0) {
                        // If this variation was previously marked for deletion in this form session,
                        // remove the hidden delete marker so it isn't deleted on submit.
                        $("#edit_purchase_requisition_form input[name='purchases_delete[]'][value='" + id + "']").remove();
                        $('#products_list tbody').append($(this));
                    }
                });
            }
        });
    }

    // Removed low-stock "Show products" loader per request

    $(document).on('click', 'button.remove_product_line', function(){
        var $tr = $(this).closest('tr');
        var vid = $tr.data('variation_id');
        if (vid) {
            $('<input>').attr({type:'hidden', name:'purchases_delete[]', value: vid}).appendTo('#edit_purchase_requisition_form');
        }
        $tr.remove();
    });

    // Comments: post and refresh
    $('#tx-post-comment').on('click', function(){
        var text = ($('#tx-new-comment').val()||'').trim();
        if(!text) return;
        var token = (document.querySelector('meta[name="csrf-token"]')||{}).getAttribute ? document.querySelector('meta[name="csrf-token"]').getAttribute('content') : '';
        if(!token){ token = '{{ csrf_token() }}'; }
        $.post("{{ route('transactions.comments.store', [$purchase->id]) }}", {comment: text, _token: token}, function(){
            $('#tx-new-comment').val('');
            $.get("{{ route('transactions.comments.index', [$purchase->id]) }}", function(data){
                var $list = $('#tx-comments-list');
                if(!data || !data.length){ $list.html('<div class="text-muted">@lang('lang_v1.no_comments_yet')</div>'); return; }
                var html='';
                data.forEach(function(it){
                    var when = (it.created_at||'').replace('T',' ').replace('Z','');
                    var who = (it.user_first_name||'') + (it.user_role?(' &bull; '+it.user_role):'');
                    html += '<div style="padding:6px 8px; border-bottom:1px solid #eee;">'
                         + '<div style="font-weight:600">'+_.escape ? _.escape(who) : who + '</div>'
                         + '<div style="white-space:pre-wrap">'+(_.escape ? _.escape(it.comment||'') : (it.comment||''))+'</div>'
                         + '<div class="text-muted" style="font-size:12px">'+when+'</div>'
                         + '</div>';
                });
                $list.html(html);
            });
        });
    });
});
</script>
@endsection
